package gov.va.genisis2.ts.common.exception;

/**
 * Exception class to handle unexpected errors in Terminology Service
 * 
 * @author Prasad Thummalapalli
 *
 */
public class TSRuntimeException extends RuntimeException {

	private static final long serialVersionUID = -177450360812316059L;

	private final String message;
	private final Throwable throwable;

	/**
	 * @param message
	 *            The error message
	 */
	public TSRuntimeException(String message) {
		super(message);
		this.message = message;
		this.throwable = null;
	}

	/**
	 * @param message
	 *            The error message
	 * @param throwable
	 *            The throwable exception
	 */
	public TSRuntimeException(String message, Throwable throwable) {
		super(message, throwable);
		this.message = message;
		this.throwable = throwable;
	}

	/**
	 * @return the message
	 */
	@Override
	public String getMessage() {
		return message;
	}

	/**
	 * @return the throwable
	 */
	public Throwable getThrowable() {
		return throwable;
	}
}